'use strict';

/* --------------------------------------------------------------
 online_manual.js 2022-11-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2022 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Add an icon containing the URL to the online manual reference
 */
(function () {
    'use strict';

    var VISIBLE_CSS_CLASS = 'visible';
    var LINK_TARGET = '_blank';

    var url = document.currentScript.dataset.url;

    var element = void 0;

    function onPageReady() {
        var request = new XMLHttpRequest();
        var baseAdminUrl = window.location.href.replace(/(\/admin\/.*)/i, '/admin/');
        var requestUrl = '' + baseAdminUrl + url + '&origin=' + encodeURIComponent(window.location.href);

        request.responseType = 'json';

        if (!element) {
            element = document.createElement('a');
            element.classList.add('online-manual-icon');
            document.body.appendChild(element);
        }

        function onLoad() {
            var response = request.response;

            if (this.status !== 200 || !response.link) {
                return;
            }

            element.href = response.link;
            element.title = response.tooltip;
            element.target = LINK_TARGET;
            element.classList.add(VISIBLE_CSS_CLASS);
        }

        request.open('GET', requestUrl, true);
        request.onload = onLoad;
        request.send();
    }

    function onHashChange() {
        element.classList.remove(VISIBLE_CSS_CLASS);
        onPageReady();
    }

    document.addEventListener('JSENGINE_INIT_FINISHED', onPageReady);
    window.addEventListener('hashchange', onHashChange);

    // Once the Admin VueJS pages are bootstrapped, the application fires the
    // "LAYOUT_BOOTSTRAPPED -> gx-admin:layout-bootstrapped" event
    // See: GambioAdmin/Layout/ui/assets/finalize.ts
    window.addEventListener('gx-admin:layout-bootstrapped', onPageReady);
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
